/*
	Main.cpp
	This file serves as the main entry point for the MUD.
	Copyright 2002 Ben Everett and Chris Horlick.
	All Rights Reserved.
*/

#include "pch.h"

// Engine Includes
#include "Socket.h"
#include "BSDSocket.h"
#include "WinSocket.h"
#include "ENGCore.h"

using namespace std;

// Functions
int main(int argc, char *argv[])
{
	CPPMUD::CENGCore *pCore = NULL;

	cout << "C++ MUD Base Code v0.1" << endl;
	cout << "Allocating engine... ";

	pCore = new CPPMUD::CENGCore;
	if (!pCore)
	{
		cout << "failed." << endl;

		return -1;
	}

	cout << "done." << endl << endl << "Entering game loop..." << endl << endl;

	pCore->EngineLoop();

	cout << endl << "Game loop complete, exiting." << endl;

	if (pCore)
		delete pCore;

	pCore = NULL;

	return 0;
}